*This code creates a merged dataset which is then used in R for analyses
*The names of the files uploaded are the standard names that the SHP uses

clear
* set your wd
cd " "

*******************************************************************************************************************************************

*Merging Together waves to create merged dataset in long format

* Changing the variable names to make it easier to convert into long format
clear
local wave = 1  /* starts a counter to indicate the wave number */
foreach y in 99 00 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 {
use shp`y'_p_user, clear
renvars idhous* idspou* age* sex* edugr* educat* occupa* wstat* is1maj*, postsub(`y')  /*getting rid of the two-digit year indicator in the variable names*/
cap renvars canton*, postsub(`y')
cap renvars civsta* ownkid* edyear*, postsub(`y')
renvars p??w101 p??p10 p??p01 p??w01 p??w02 p??w03 p??w06, presub (p`y' p)
cap renvars p??p45, presub (p`y' p)
cap renvars p??p02, presub (p`y' p)
cap renvars p??p06, presub (p`y' p)
cap renvars p??n43, presub (p`y' p)
cap renvars p??p04, presub (p`y' p)
cap renvars p??p13, presub (p`y' p)
cap renvars p??p17, presub (p`y' p)
cap renvars p??p19, presub (p`y' p)
cap renvars p??n42, presub (p`y' p)
cap renvars p??w237, presub (p`y' p)
cap renvars p??w105, presub (p`y' p)
cap renvars p??a26, presub (p`y' p)
cap renvars p??a32, presub (p`y' p)
cap renvars p??n39, presub (p`y' p)
cap renvars p??n40, presub (p`y' p)
cap renvars p??n41, presub (p`y' p)
cap renvars p??n42, presub (p`y' p)
cap renvars p??n43, presub (p`y' p)
cap renvars p??n44, presub (p`y' p)
cap renvars p??n45, presub (p`y' p)
cap renvars p??n46, presub (p`y' p)
cap renvars p??n47, presub (p`y' p)
cap renvars p??p01, presub (p`y' p)
cap renvars p??p02, presub (p`y' p)
cap renvars p??p03, presub (p`y' p)
cap renvars p??p04, presub (p`y' p)
cap renvars p??p06, presub (p`y' p)
cap renvars p??p26, presub (p`y' p)
cap renvars p??p66, presub (p`y' p)
cap renvars p??p67, presub (p`y' p)
cap renvars p??p68, presub (p`y' p)
cap renvars p??p10, presub (p`y' p)
cap renvars p??p11, presub (p`y' p)
cap renvars p??c44, presub (p`y' p)
cap renvars p??i01, presub (p`y' p)
cap renvars p??i02, presub (p`y' p)
cap renvars i??eqsg i??eqog, presub (i`y' i)
cap renvars i??ptotg, presub (i`y' i)
renvars x??i04 x??e02, presub (x`y' x)
gen wave=`wave' /*creates a variable to index the wave*/
local wave = `wave' + 1 /*this sets the wave number for the next survey*/

cap gen pp45=.
cap gen pa26=.
cap gen pa32=.
cap gen pn39=.
cap gen pn40=.
cap gen pn41=.
cap gen pn42=.
cap gen pn43=.
cap gen pn44=.
cap gen pn45=.
cap gen pn46=.
cap gen pn47=.
cap gen pp01=.
cap gen pp02=.
cap gen pp03=.
cap gen pp04=.
cap gen pp06=.
cap gen pp10=.
cap gen pp11=.
cap gen pp13=.
cap gen pp17=.
cap gen pp19=.
cap gen pp26=.
cap gen pp66=.
cap gen pp67=.
cap gen pp68=.
cap gen pc44=.
cap gen pi01=.
cap gen pi02=.

cap gen iptotg=.
cap gen xi04=.
cap gen xe02=.
cap gen pw237=.
cap gen pw105=.

save tempp`y', replace
}

use tempp18, clear

drop pa26 pa32 pn39 pn40 pn41 pn42 pn43 pn44 pn45 pn46 pn47 pp02 pp03 pp04 pp06 pp11 pp13 pp17 pw237 pw105 pp26

foreach y in 99 00 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 {
append using tempp`y', keep(wave idpers idhous idspou age sex edugr educat occupa wstat is1maj civsta ownkid edyear pw101 pp10 pp01 pw01 pw02 pw03 pw06 pp13 pp17 pw237 pw105 pa26 pa32 pn39 pn40 pn41 pn42 pn43 pn44 pn45 pn46 pn47 pp01 pp02 pp03 pp04 pp06 pp11 pc44 pi01 pi02 iptotg xi04 xe02 pp19 pp45 pp66 pp67 pp68)
}

keep wave idpers idhous idspou age sex edugr educat occupa wstat is1maj civsta ownkid edyear pw101 pp10 pp01 pw01 pw02 pw03 pw06 pp13 pp17 pw237 pw105 pa26 pa32 pn39 pn40 pn41 pn42 pn43 pn44 pn45 pn46 pn47 pp01 pp02 pp03 pp04 pp06 pp11 pc44 pi01 pi02 iptotg xi04 xe02 pp19 pp45 pp66 pp67 pp68

gen year=.
replace year=1999 if wave==1
replace year=2000 if wave==2
replace year=2001 if wave==3
replace year=2002 if wave==4
replace year=2003 if wave==5
replace year=2004 if wave==6
replace year=2005 if wave==7
replace year=2006 if wave==8
replace year=2007 if wave==9
replace year=2008 if wave==10
replace year=2009 if wave==11
replace year=2010 if wave==12
replace year=2011 if wave==13
replace year=2012 if wave==14
replace year=2013 if wave==15
replace year=2014 if wave==16
replace year=2015 if wave==17
replace year=2016 if wave==18
replace year=2017 if wave==19
replace year=2018 if wave==20

gen month=1+((wave-1)*12)

order wave, first
order idpers, first
sort idpers wave

la var pa26 "Internet: Time in minutes per week"
la var pa32	"Internet: Use for reading newspapers"
la de pa32 1 "Several times a day" 2 "Once a day" 3 "At least once a week" 4 "At least once a month" 5 "Less frequently" 6 "Never"
la val pa32 pa32
la var pn39	"Association membership: Local or parents"
la de pn39 1 "Active member" 2 "Passive member" 3 "Not a member"
la val pn39 pn39
la var wave "Panel Wave no."
la var year "Year"
la var pp19 "Party Vote Choice Tomorrow"
la de pp19 1 "PRD Swiss Radical-Democratic Party" 2 "PDC Swiss Christian-Democrat Party" 3 "PSS Swiss Socialist Party" 4 "UDC - Democratic Union of the Centre" 5 "PLS Swiss Liberal Party" 7 "PEV Swiss (Pop) Evang Party" 8 "PCS Swiss Christian Social Party" 9 "PST Swiss Labour Party/Popular Labour Party" 10 "AVF Socialist Green Alternative and Wom" 11 "PES Swiss Ecology Party" 12 "DS Swiss Democrats (former National Act)" 13 "UDF Federal Democratic Union" 15 "Lega dei ticinesi" 16 "Other Party" 20 "GL Green liberals" 21 "BDP Conservative Democratic Party" 22 "FDP The Liberals" 50 "Vote for a candidate, not a party" 51 "For no party" 52 "Wouldn't vote'"
la var pp45 "General trust in people"
la de pp45 0 "Can't be too careful" 10 "Most people can be trusted"
la var pp66 "Party identification: Any"
la de pp66 1 "Yes" 2 "No"
la var pp67 "Party identification: Party"
la de pp67 1 "PRD Swiss Radical-Democratic Party" 2 "PDC Swiss Christian-Democrat Party" 3 "PSS Swiss Socialist Party" 4 "UDC - Democratic Union of the Centre" 5 "PLS Swiss Liberal Party" 7 "PEV Swiss (Pop) Evang Party" 8 "PCS Swiss Christian Social Party" 9 "PST Swiss Labour Party/Popular Labour Party" 10 "AVF Socialist Green Alternative and Wom" 11 "PES Swiss Ecology Party" 12 "DS Swiss Democrats (former National Act)" 13 "UDF Federal Democratic Union" 15 "Lega dei ticinesi" 16 "Other Party" 20 "GL Green liberals" 21 "BDP Conservative Democratic Party" 22 "FDP The Liberals" 
la var pp68 "Party identification: Proximity"
la de pp68 1 "Very close" 2 "Quite close" 3 "Not very close"

recode idpers wave idhous sex age idspou civsta ownkid educat edugr edyear occupa pc44 wstat pw01 pw02 pw03 pw06 pw101 is1maj pi01 pi02 iptotg pp01 pp10 xe02 xi04 pw237 pw105 pn39 pn40 pn41 pn42 pn43 pn44 pn45 pn46 pn47 pp02 pp03 pp04 pp06 pp11 pp13 pp17 pa26 pa32 pp45 pp66 pp67 pp68 (min/-1=.)

*Education
recode educat (0 1 2 3=1) (4 5 6=2) (7 8 9 10=3),gen(edu3)
recode edugr (0 1 2 3=1) (4 5 6=2) (7 8 9 10=3),gen(edu3_hh)
replace edu3=edu3_hh if edu3==.
la de edu3 1 "Primary/None" 2 "Secondary" 3 "University"
la val edu3 edu3
la var edu3 "Education - 3 Categories"

*Employment
recode wstat (1=1) (2=4) (3=4),gen(workstatus)
replace workstatus=2 if occupa==4
replace workstatus=3 if occupa==8
la de workstatus 1 "Employed" 2 "Student" 3 "Retired" 4 "Unemployed/Other"
la val workstatus workstatus
la var workstatus "Work Status"

*Income
xtile income3=iptotg,n(3)
xtile income10=iptotg,n(10)
gen income=income10
la var income3 "Income - 3 Categories"
la var income "Income - 10 Categories"

gen long id=idpers

sort idpers wave
by idpers, sort: gen id_n=_n

gen polint=pp01
gen leftright=pp10
gen gender=sex
recode polint (0/3=1) (4/7=2) (8/10=3)
